VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3540
   ClientLeft      =   2355
   ClientTop       =   1695
   ClientWidth     =   5760
   LinkTopic       =   "Form1"
   ScaleHeight     =   3540
   ScaleWidth      =   5760
   Begin VB.TextBox Text1 
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      MultiLine       =   -1  'True
      TabIndex        =   6
      Text            =   "frmMain.frx":0000
      Top             =   2880
      Width           =   4575
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop DI Task"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   4
      Top             =   1800
      Width           =   1695
   End
   Begin VB.ListBox List1 
      Height          =   450
      Left            =   2520
      TabIndex        =   3
      Top             =   1200
      Width           =   1815
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Start Continuous DI"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Top             =   1200
      Width           =   1695
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize Device 0"
      Height          =   375
      Left            =   600
      TabIndex        =   0
      Top             =   600
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   3840
      Top             =   360
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   3120
      Top             =   360
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label3 
      Caption         =   "bit 3..............bit 0"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   3360
      TabIndex        =   7
      Top             =   2400
      Width           =   1095
   End
   Begin VB.Shape PortCBit 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   3
      Left            =   3360
      Shape           =   3  'Circle
      Top             =   2160
      Width           =   255
   End
   Begin VB.Shape PortCBit 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   2
      Left            =   3600
      Shape           =   3  'Circle
      Top             =   2160
      Width           =   255
   End
   Begin VB.Shape PortCBit 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   1
      Left            =   3840
      Shape           =   3  'Circle
      Top             =   2160
      Width           =   255
   End
   Begin VB.Shape PortCBit 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   0
      Left            =   4080
      Shape           =   3  'Circle
      Top             =   2160
      Width           =   255
   End
   Begin VB.Label Label2 
      BackColor       =   &H8000000E&
      Height          =   255
      Left            =   2520
      TabIndex        =   5
      Top             =   1800
      Width           =   1815
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   240
      TabIndex        =   2
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit ' require variable declaration

' tested in Win2K SP4 with DriverLINX version kpcmcia-850A04
' and a KPCMCIA-PIO24-C

' Purpose:  digital Port C, channel 2, can be used to generate IRQ
' DriverLINX supports these as paceding sources for an IRQ mode DO task
'
' this example enables the four low order bits of Port C to generate IRQ
' that will be used to pace a DI task.  In response to each falling edge
' at any of the enabled lines, Port C will be read once and a buffer filled
' message will be posted.  The event procedure for this will get the data from
' port C and from that can determine which line among the 4 was at a logic 0
' state...and hence caused the IRQ.
'
' for PCI bus implementation of this, look to the KPCI-3140.  It rocks!

Const UseDIEventForTiming = True

Dim DIData() As Byte  ' an array for data from the buffers
Dim i As Integer

Private Sub cmdInit_Click()
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "KPCPIO"  ' give driver name to avoid Open DriverLINX dialog
.Req_device = 0  ' dev number from DLinx Config Panel
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
' use of the LDD control is not required
If SR.Res_result = DL_NoErr Then
cmdSample.Enabled = True
LDD.device = 0
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.Refresh
Form1.Caption = LDD.Dev_Model  'from the LDD, determine the model number
Else
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If
' the LDD control can inform your application
' about the features of the hardware

Form1.SetFocus  ' return focus to our app
End Sub

Private Sub cmdSample_Click()

SetupDInonStop
ReDim DIData(SR.Sel_buf_samples) As Byte
SR.Refresh  ' start the DI task that will sample at edge on any of the
            ' enabled lines in Port C
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
' see Private Sub SR_BufferFilled() for what happens next
If SR.Res_result = DL_NoErr Then
cmdStop.Enabled = True
cmdSample.Enabled = False
End If

End Sub

Private Sub cmdStop_Click()
With SR
.Req_op = DL_STOP
.Refresh
End With
If SR.Res_result = DL_NoErr Then
cmdStop.Enabled = False
cmdSample.Enabled = True
End If
End Sub

Private Sub Form_Terminate()
'call code to stop the task just in case it is still running
cmdStop_Click
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

Sub SetupDInonStop()
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_INTERRUPT
.Req_subsystem = DL_DI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_COMMAND  ' stop when Stop Operation is executed
' indeterminate sampling duration (stp on command or trigger) has
' impacts on buffering requirements
Const Rising_Edge = 0
Const Falling_Edge = 1

If UseDIEventForTiming Then
    .Evt_Tim_type = DL_DIEVENT
    .Evt_Tim_diChannel = 2
    .Evt_Tim_diMatch = DL_NotEquals       ' <> means edge
    .Evt_Tim_diMask = &HF  ' enable the lower 4 bits of the port
    .Evt_Tim_diPattern = Falling_Edge * .Evt_Tim_diMask  ' <>0 means rising edge
Else
.Evt_Tim_type = DL_RATEEVENT ' timing will be used
.Evt_Tim_rateChannel = DL_DEFAULTTIMER  ' each board has default timing channel
.Evt_Tim_rateClock = DL_INTERNAL1       ' internal1 timebase
.Evt_Tim_rateGate = DL_NOCONNECT   ' no gating
.Evt_Tim_rateMode = DL_RATEGEN     ' one sample for each tic of clock
.Evt_Tim_rateOnCount = 0   ' not used for RATEGEN
.Evt_Tim_rateOutput = CT_Output_Default ' not used for RATEGEN
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 10) ' 10 Hz rate
.Evt_Tim_ratePulses = 0  ' not used for RATEGEN
End If
' Select Group
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' a start channel only
.Sel_chan_start = 2            ' start on channel 0
.Sel_chan_startGainCode = .DLGain2Code(-1) ' negative = bipolar, 1 = gain of 1
.Sel_chan_stop = 2
.Sel_chan_stopGainCode = .DLGain2Code(-1) 'stop channel
' allocate several buffers of 1 sample each for the data
.Sel_buf_N = 255                 ' max number of buffers used
.Sel_buf_samples = 1             ' one sample per buffer
' when stop condition is command or trigger, must have minimum of 3 buffers
' and the total buffer size should approximate at least 1 second worth of data

' the buffer MUST be a multiple of how many channels are in the scan, e.g., 8, 16, etc.
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message

End With
End Sub

Private Sub SR_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)

Static bufCounter As Long
bufCounter = bufCounter + 1

List1.Clear  ' clear the list box
Label2.Caption = "Processing event #: " & Str(bufCounter)
' the BufferFilled message contains the bufIndex that is ready for conversion
SR.VBArrayBufferXfer bufIndex, DIData, DL_BufferToVBArray

List1.AddItem Hex(DIData(0) And &HF)   ' mask off upper 4 bits

For i = 0 To 3   ' interrogate individual line
    If (DIData(0) And (2 ^ i)) / (i + 1) = 1 Then
    PortCBit(i).FillColor = vbGreen
    Else
    PortCBit(i).FillColor = vbRed
    End If
Next i

' assuming falling edge caused the sample/bufferFilled message
' then a logic 0 state is indicative that that line caused the message
' that brought us here

' for the sample rate, assign buffer size so that BufferFilled messages are not
' sent at a rate faster than is practical for Windows message queue processing,
' e.g., not faster than appx 10 msec rate
End Sub

Private Sub SR_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
' a Data Lost message could result if buffer size is too small for the
' the requested sample rate
'
MsgBox "Data Lost Message has Occured...try increasing size of or number of buffers", vbOKOnly

cmdSample.Enabled = True
'
' could just restart the acquisition from here or take other corrective actions
'With SR
'.Req_op = DL_START
'.Refresh
'End With
End Sub

